/*------------------------------------------------------------------------------
						HDR
------------------------------------------------------------------------------*/

float4 HDRPass( float4 colorInput, float2 Tex )
{
	float4 HDR = colorInput;
	float4 c_center = tex2D(s0, Tex.xy).rgba;
	float4 bloom_sum1 = float4(0.0, 0.0, 0.0, 0.0);
	float4 bloom_sum2 = float4(0.0, 0.0, 0.0, 0.0);
	Tex += float2(0.3, 0.3);
	float radius1 = 1;
	bloom_sum1 += tex2D(s0, Tex + float2(-1.5, -1.5) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(-2.5, 0) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(-1.5, 1.5) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(0, 2.5) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(1.5, 1.5) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(2.5, 0) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(1.5, -1.5) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(0, -2.5) * radius1);
	bloom_sum1 *= 0.025;
	bloom_sum1 -= float4(0.1, 0.1, 0.1, 0.1);
	bloom_sum1 = max(bloom_sum1, float4(0,0,0,0));
	bloom_sum2 += tex2D(s0, Tex + float2(-1.5, -1.5) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(-2.5, 0) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(-1.5, 1.5) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(0, 2.5) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(1.5, 1.5) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(2.5, 0) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(1.5, -1.5) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(0, -2.5) * radius2);
	bloom_sum2 *= 0.025;
	bloom_sum2 -= float4(0.1, 0.1, 0.1, 0.1);
	bloom_sum2 = max(bloom_sum1, float4(0,0,0,0));
	float2 vpos = (Tex - float2(0.5, 0.5)) * 2;
	float dist = (dot(vpos, vpos));
	dist = radius2*dist - radius1*dist;
	HDR = (c_center * 0.4 + bloom_sum1) * dist;
	float4 blend = HDR + colorInput;
	HDR += pow(blend, HDRPower) ;
	return HDR;
}